﻿using Prism.Ioc;
using Prism.Unity;
using System.Windows;

namespace WpfPrism
{
	/// <summary>
	/// Interaction logic for App.xaml
	/// </summary>
	public partial class App : PrismApplication
	{
		protected override void RegisterTypes(IContainerRegistry containerRegistry)
		{
			containerRegistry.RegisterForNavigation<MainWindow, ViewModels.MainWindowViewModel>();
			containerRegistry.RegisterForNavigation<FilmsView, ViewModels.FilmsViewModel>();
			containerRegistry.RegisterForNavigation<BooksView, ViewModels.BooksViewModel>();
		}

		protected override Window CreateShell()
		{
			var w = Container.Resolve<MainWindow>();
			return w;
		}
	}
}
