﻿using System;
using System.ComponentModel;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;

namespace MyControls
{
	public class MyControlTitleContent : Control
	{
		// dependency properties
		public static readonly DependencyProperty MyTitleProperty = DependencyProperty.Register(nameof(MyTitle), typeof(string),
			typeof(MyControlTitleContent), new FrameworkPropertyMetadata(string.Empty, FrameworkPropertyMetadataOptions.Inherits));

		public static readonly DependencyProperty MyTextProperty = DependencyProperty.Register(nameof(MyText), typeof(string),
			typeof(MyControlTitleContent), new FrameworkPropertyMetadata(string.Empty, FrameworkPropertyMetadataOptions.Inherits));

		public static readonly DependencyProperty MyBackgroundProperty = DependencyProperty.Register(nameof(MyBackground), typeof(Brush),
			typeof(MyControlTitleContent), new FrameworkPropertyMetadata(Brushes.Gray, FrameworkPropertyMetadataOptions.AffectsRender | FrameworkPropertyMetadataOptions.AffectsMeasure));

		public static readonly DependencyProperty MyFontSizeProperty = DependencyProperty.Register(nameof(MyFontSize), typeof(double),
			typeof(MyControlTitleContent), new FrameworkPropertyMetadata(16.0, FrameworkPropertyMetadataOptions.AffectsRender | FrameworkPropertyMetadataOptions.AffectsMeasure));

		// properties
		[Bindable(true)]
		[Category("Data"), Description("My title")]
		public string MyTitle
		{
			get => (string)GetValue(MyTitleProperty);
			set => SetValue(MyTitleProperty, value);
		}

		[Bindable(true)]
		[Category("Data"), Description("My text")]
		public string MyText
		{
			get => (string)GetValue(MyTextProperty);
			set => SetValue(MyTextProperty, value);
		}

		[Category("Appearance")]
		public Brush MyBackground
		{
			get => (Brush)GetValue(MyBackgroundProperty);
			set => SetValue(MyBackgroundProperty, value);
		}

		[Category("Appearance")]
		public double MyFontSize
		{
			get => (double)GetValue(MyFontSizeProperty);
			set => SetValue(MyFontSizeProperty, value);
		}

		// constructor
		static MyControlTitleContent()
		{
			DefaultStyleKeyProperty.OverrideMetadata(typeof(MyControlTitleContent), new FrameworkPropertyMetadata(typeof(MyControlTitleContent)));
		}
	}
}
