﻿using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;
using System.Windows.Media.Imaging;

namespace WpfApp1
{
	public class MyCanvas : Canvas
	{
		protected BitmapImage _imageFile1;
		protected Point _imagePos1;
		protected Size _imageSize1;
		protected int _imageGoXStep1;

		public void LoadFromResource()
		{
			// load file
			string pathImage = "pack://application:,,,/WpfApp1;component/tree.jpg";
			_imageFile1 = new BitmapImage(new Uri(pathImage, UriKind.Absolute));
			_imagePos1 = new Point(10, 15);
			_imageSize1 = new Size(50, 50);
			_imageGoXStep1 = 1;
		}

		protected override void OnRender(DrawingContext drawingContext)
		{
			drawingContext.DrawImage(_imageFile1, new System.Windows.Rect(_imagePos1, _imageSize1));
		}

		public void MoveObjects()
		{
			_imagePos1.X += _imageGoXStep1;
		}

		public void ReDraw()
		{
			// InvalidateVisual() says Canvas to call OnRender
			InvalidateVisual();
		}
	}

	// MainWindow
	public partial class MainWindow : Window
	{
		protected MyCanvas _myCanvas;
		protected System.Windows.Threading.DispatcherTimer myTimer;
		protected int TimeStepInMilliseconds = 100; // 1/10 second

		public MainWindow()
		{
			InitializeComponent();

			// remove child elements
			Content = null;

			// add Canvas
			_myCanvas = new MyCanvas();
			AddChild(_myCanvas);

			// init my objects
			_myCanvas.LoadFromResource();

			// timer
			myTimer = new System.Windows.Threading.DispatcherTimer();
			myTimer.Tick += new EventHandler(OnMyTimerTick);
			myTimer.Interval = new TimeSpan(0, 0, 0, 0, TimeStepInMilliseconds); // in milli second
			myTimer.Start();
		}

		private void OnMyTimerTick(object sender, EventArgs e)
		{
			_myCanvas.ReDraw();
			_myCanvas.MoveObjects();
		}
	}
}