﻿using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using System;
using System.Windows;
using WpfApp1.Models;
using WpfApp1.Services;

namespace WpfApp1
{
	public partial class App : Application
	{
		private readonly IHost host;

		public App()
		{
			host = Host.CreateDefaultBuilder()
					.ConfigureAppConfiguration((context, builder) =>
					{
						builder.AddJsonFile("appsettings.json", optional: true);
					}).ConfigureServices((context, services) =>
					{
						ConfigureServices(context.Configuration, services);
					})
					.ConfigureLogging(logging =>
					{
						// Add other loggers...
					})
					.Build();
		}

		private void ConfigureServices(IConfiguration configuration, IServiceCollection services)
		{
			services.Configure<AppSettings>(configuration.GetSection(nameof(AppSettings)));
			services.AddScoped<ISampleService, SampleService>();

			services.AddSingleton<MainWindow>();
		}

		protected override async void OnStartup(StartupEventArgs e)
		{
			await host.StartAsync();

			var mainWindow = host.Services.GetRequiredService<MainWindow>();
			mainWindow.Show();

			base.OnStartup(e);
		}

		protected override async void OnExit(ExitEventArgs e)
		{
			using (host)
			{
				await host.StopAsync(TimeSpan.FromSeconds(5));
			}

			base.OnExit(e);
		}
	}
}