﻿using System.Collections.ObjectModel;
using System.Windows;
using System.Windows.Controls;

namespace WpfListViewAutoColumnWidth
{
    public class MyShop
    {
        public string PlaceToBuy { get; set; }
    }

    public partial class MainWindow : Window
    {
        public ObservableCollection<MyShop> MyData { get; set; }

        public MainWindow()
        {
            InitializeComponent();

            // for binding
            DataContext = this;

            // set my data
            MyData = new ObservableCollection<MyShop>();

            // collection chnged
            MyData.CollectionChanged += (a, b) =>
            {
                // auto column width for ListView
                var listView = (MyListView1.View as GridView);
                listView.Columns[0].Width = 0;
                listView.Columns[0].Width = double.NaN;
            };
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            MyData.Add(
                 new MyShop() { PlaceToBuy = MyText1.Text }
            );
        }
    }
}