﻿using Microsoft.Win32;
using System.Windows;
using System.Windows.Media.Imaging;
using System.Windows.Media;
using System.Windows.Input;
using System.ComponentModel;
using System.Runtime.CompilerServices;

namespace WpfApp1
{
	public class MainWindowModel : NotifyPropertyChanged
	{
		private ImageSource _imageSource;
		public ImageSource ImageSource
		{
			get => _imageSource;
			set => SetProperty(ref _imageSource, value);
		}
		public ICommand CommandClickLoadImage => new ClickCommand(ClickLoadImage);

		public MainWindowModel()
		{
		}
		private void ClickLoadImage(object parameter)
		{
			OpenFileDialog op = new OpenFileDialog();
			op.Title = "Select a picture";
			op.Filter = "All supported graphics|*.jpg;*.jpeg;*.png|" +
			  "JPEG (*.jpg;*.jpeg)|*.jpg;*.jpeg|" +
			  "Portable Network Graphic (*.png)|*.png";
			if (op.ShowDialog() == true)
			{
				ImageSource = new BitmapImage(new Uri(op.FileName));
			}
		}
	}

	public partial class MainWindow : Window
	{
		public MainWindowModel MyModel { get; }

		public MainWindow()
		{
			MyModel = new MainWindowModel();

			// for binding
			this.DataContext = this;
		}
	}

	///// Base functionality /////
	public class NotifyPropertyChanged : INotifyPropertyChanged
	{
		public event PropertyChangedEventHandler PropertyChanged;
		protected void OnPropertyChanged([CallerMemberName] string name = null)
		{
			PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(name));
		}
		protected virtual bool SetProperty<T>(ref T field, T value, [CallerMemberName] string PropertyName = null)
		{
			if (Equals(field, value))
				return false;
			field = value;
			OnPropertyChanged(PropertyName);
			return true;
		}
	}

	class ClickCommand : ICommand
	{
		public event EventHandler CanExecuteChanged;
		private Action<object> _callback;
		public ClickCommand(Action<object> callback)
		{
			_callback = callback;
		}
		public virtual void Execute(object parameter) { _callback(parameter); }
		public virtual bool CanExecute(object parameter) { return true; }
	}
	////////////
}