﻿using System;
using System.Collections.ObjectModel;
using System.Windows;
using System.Windows.Input;

namespace WpfDataGrid
{
	public class MyShop
	{
		public string Customer { get; set; }
		public string Item { get; set; }
		public string Price { get; set; }
	}

	class ButtonCommand : ICommand
	{
		public event EventHandler CanExecuteChanged;
		private Action<object> _callback;
		public ButtonCommand(Action<object> callback)
		{
			_callback = callback;
		}
		public virtual void Execute(object parameter) { _callback(parameter); }
		public virtual bool CanExecute(object parameter) { return true; }
	}

	public partial class MainWindow : Window
	{
		public ObservableCollection<MyShop> MyData { get; set; }
		public ICommand ClickMyButton1 { get; set; }

		public MainWindow()
		{
			InitializeComponent();

			// for binding
			this.DataContext = this;

			// data for grid
			MyData = new ObservableCollection<MyShop>()
			   {
					new MyShop() {Customer="ACME", Item="Widget", Price="100"},
					new MyShop() {Customer="ACME", Item="Widget", Price="100"},
					new MyShop() {Customer="ACME", Item="Tyre", Price="200"},
					new MyShop() {Customer="Amazon", Item="Pen", Price="50"},
					new MyShop() {Customer="Amazon", Item="Paper", Price="20"},
					new MyShop() {Customer="Autodesk", Item="CAD", Price="10"},
					new MyShop() {Customer="Autodesk", Item="File", Price="40"},
					new MyShop() {Customer="ABC", Item="Flowers", Price="503"},
					new MyShop() {Customer="ABC", Item="Sand", Price="706"}
			   };

			ClickMyButton1 = new ButtonCommand((parameter => {
				MyShop myShop = parameter as MyShop;
			}));
		}

	}
}