﻿using System.Drawing;
using System.IO;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Resources;

namespace WpfApp1
{
	public class MyCanvas : Canvas
	{
		protected System.Drawing.Image _image1;
		protected System.Windows.Point _imagePos1;
		protected System.Windows.Size _imageSize1;
		protected int _imageGoXStep1;

		// sprit
		int SpriteIndex;
		Rectangle[] SpriteOffsets;

		public void LoadFromResource()
		{
			// load file
			StreamResourceInfo sri = Application.GetResourceStream(new Uri("dog_run.png", UriKind.Relative));
			if (sri != null)
			{
				using (Stream s = sri.Stream)
				{
					_image1 = System.Drawing.Image.FromStream(s);
				}
			}

			// set sprite rectangle
			SpriteIndex = 0;
			SpriteOffsets = new Rectangle[]{
					new Rectangle(244, 3, 57, 42),
					new Rectangle(304, 4, 54, 39),
					new Rectangle(363, 4, 57, 38),
					new Rectangle(420, 1, 55, 40),
					new Rectangle(483, 4, 57, 36),
					new Rectangle(542, 4, 57, 38),
			   };

			// position
			_imagePos1 = new System.Windows.Point(10, 15);
			_imageSize1 = new System.Windows.Size(50, 50);
			_imageGoXStep1 = 4;
		}

		protected override void OnRender(DrawingContext drawingContext)
		{
			if (SpriteIndex < 0 || SpriteIndex >= SpriteOffsets.Length)
				SpriteIndex = 0;

			Rectangle rect = SpriteOffsets[SpriteIndex];

			DrawPartImage(drawingContext, _imagePos1, _image1, rect);

			// next index
			SpriteIndex++;
		}

		public void DrawPartImage(DrawingContext drawingContext, System.Windows.Point pos, System.Drawing.Image imageFile, Rectangle part)
		{
			// Вырезаем выбранный кусок картинки
			Bitmap bmpPart = new Bitmap(part.Width, part.Height);
			using (Graphics g = Graphics.FromImage(bmpPart))
			{
				g.DrawImage(imageFile, new Rectangle(0, 0, part.Width, part.Height), (float)part.X, (float)part.Y, (float)part.Width, (float)part.Height, GraphicsUnit.Pixel);
			}

			// convert to image source
			MemoryStream ms = new MemoryStream();
			((System.Drawing.Bitmap)bmpPart).Save(ms, System.Drawing.Imaging.ImageFormat.Png);
			BitmapImage bmpImage = new BitmapImage();
			bmpImage.BeginInit();
			ms.Seek(0, SeekOrigin.Begin);
			bmpImage.StreamSource = ms;
			bmpImage.EndInit();

			// draw image
			System.Windows.Size size = new System.Windows.Size(part.Width, part.Height);
			drawingContext.DrawImage(bmpImage, new System.Windows.Rect(pos, size));
		}

		public void MoveObjects()
		{
			_imagePos1.X += _imageGoXStep1;
		}

		public void ReDraw()
		{
			// InvalidateVisual() says Canvas to call OnRender
			InvalidateVisual();
		}
	}

	// MainWindow
	public partial class MainWindow : Window
	{
		protected MyCanvas _myCanvas;
		protected System.Windows.Threading.DispatcherTimer myTimer;
		protected int TimeStepInMilliseconds = 100; // 1/10 second

		public MainWindow()
		{
			InitializeComponent();

			// remove child elements
			Content = null;

			// add Canvas
			_myCanvas = new MyCanvas();
			AddChild(_myCanvas);

			// init my objects
			_myCanvas.LoadFromResource();

			// timer
			myTimer = new System.Windows.Threading.DispatcherTimer();
			myTimer.Tick += new EventHandler(OnMyTimerTick);
			myTimer.Interval = new TimeSpan(0, 0, 0, 0, TimeStepInMilliseconds); // in milli second
			myTimer.Start();
		}

		private void OnMyTimerTick(object sender, EventArgs e)
		{
			_myCanvas.ReDraw();
			_myCanvas.MoveObjects();
		}
	}
}