﻿using System;
using System.Text;
using System.Threading.Tasks;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.Devices.PointOfService;
using Windows.Storage;

namespace AppUWP1
{
	public sealed partial class MainPage : Page
	{
		public MainPage()
		{
			this.InitializeComponent();
			this.Loaded += MainPage_Loaded;
		}

		private void MainPage_Loaded(object sender, RoutedEventArgs e)
		{
			Task.Run(async () =>
			{
				// load bitmap
				var bitmapStream = await HelperPosPrinterImageResize.ConvertFileToStream(Windows.Storage.ApplicationData.Current.LocalFolder, "my_for_pos_printer.jpg");

				// find printer
				Windows.Devices.PointOfService.PosPrinter posPrinter = await HelperPosPrinter.FindPosPrinterAsync();
				ClaimedPosPrinter claimedPrinter = await posPrinter.ClaimPrinterAsync();
				ReceiptPrintJob job = await HelperPosPrinter.PreparePrinter(claimedPrinter);

				// print image
				uint maxWidth = claimedPrinter.Receipt.LineWidth;
				await HelperPosPrinterImageResize.PrintImageWithResize(job, bitmapStream, PosPrinterAlignment.Center, maxWidth);

				// print text
				StringBuilder bodyToPrint = new StringBuilder();
				bodyToPrint.AppendLine("Hello");
				bodyToPrint.AppendLine("Thank you");
				HelperPosPrinter.PrintText(job, bodyToPrint.ToString());

				// finish
				bool result = await HelperPosPrinter.FinishPrint(job, claimedPrinter);
			});
		}
	}
}