﻿using System;
using System.Linq;
using System.Threading.Tasks;

using Windows.Devices.Enumeration;
using Windows.Devices.PointOfService;
using Windows.Graphics.Imaging;
using Windows.Storage.Streams;
using Windows.Storage;

namespace AppUWP1
{
	public class HelperPosPrinter
	{
		public static async Task<BitmapFrame> ConvertFileToBitmap(StorageFolder storageFolder, string filename)
		{
			try
			{
				StorageFile file = await storageFolder.GetFileAsync(filename);
				using (IRandomAccessStream stream = await file.OpenAsync(FileAccessMode.Read))
				{
					BitmapDecoder bitmapDecoder = await BitmapDecoder.CreateAsync(stream);
					return await bitmapDecoder.GetFrameAsync(0);
				}
			}
			catch (Exception ex)
			{
			}
			return null;
		}

		public static async Task<Windows.Devices.PointOfService.PosPrinter> FindPosPrinterAsync()
		{
			try
			{
				string posAsql = Windows.Devices.PointOfService.PosPrinter.GetDeviceSelector();
				DeviceInformationCollection deviceCollection = await DeviceInformation.FindAllAsync(posAsql);

				int count = deviceCollection.Count();
				foreach (var item in deviceCollection)
				{
					var printer = await Windows.Devices.PointOfService.PosPrinter.FromIdAsync(item.Id);
					if (printer != null)
						return printer;
				}
			}
			catch (Exception)
			{
			}
			return null;
		}

		public static async Task<ReceiptPrintJob> PreparePrinter(ClaimedPosPrinter claimedPrinter)
		{
			await claimedPrinter.EnableAsync();

			claimedPrinter.Receipt.CharactersPerLine = 56;
			claimedPrinter.Receipt.LineSpacing = 20;
			claimedPrinter.Receipt.IsLetterQuality = true;

			return claimedPrinter.Receipt.CreateJob();
		}

		public static void PrintImage(ReceiptPrintJob job, BitmapFrame bitmapFrame, PosPrinterAlignment align, uint maxWidth)
		{
			try
			{
				job.PrintBitmap(bitmapFrame, align);
			}
			catch (Exception ex)
			{
			}
		}

		public static void PrintText(ReceiptPrintJob job, string textToPrint)
		{
			job.Print(textToPrint);
		}

		public static async Task<bool> FinishPrint(ReceiptPrintJob job, ClaimedPosPrinter claimedPrinter)
		{
			try
			{
				bool result = await job.ExecuteAsync();
				claimedPrinter.Dispose();
				return result;
			}
			catch (Exception e)
			{
			}
			return false;
		}

	}
}