﻿using System;
using System.ComponentModel;
using System.Runtime.CompilerServices;
using System.Windows;
using System.Windows.Input;

namespace WpfAppAnimal
{
    public partial class MainWindow : Window
    {
        public MyModel MyModel { get; }
        public MainWindow()
        {
            MyModel = new MyModel();

            // for binding
            this.DataContext = this;

            InitializeComponent();
        }
    }

    public class MyModel : INotifyPropertyChanged
    {
        public string AnimalName { get; set; }

        private string _lifeTime;
        public string LifeTime
        {
            get => _lifeTime;
            set => SetProperty(ref _lifeTime, value);
        }
        public ICommand ClickMyButton1 { get; set; }
        public MyModel()
        {
            // button handler
            ClickMyButton1 = new ButtonCommand((parameter) => {

                if (AnimalName == "cat")
                    LifeTime = "12 years";
                else if (AnimalName == "dog")
                    LifeTime = "16 years";
            });
        }

        public event PropertyChangedEventHandler PropertyChanged;
        protected void OnPropertyChanged([CallerMemberName] string name = null)
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(name));
        }
        protected virtual bool SetProperty<T>(ref T field, T value, [CallerMemberName] string PropertyName = null)
        {
            if (Equals(field, value)) return false;
            field = value;
            OnPropertyChanged(PropertyName);
            return true;
        }
    }

    class ButtonCommand : ICommand
    {
        public event EventHandler CanExecuteChanged;
        private Action<object> _callback;
        public ButtonCommand(Action<object> callback)
        {
            _callback = callback;
        }
        public virtual void Execute(object parameter) { _callback(parameter); }
        public virtual bool CanExecute(object parameter) { return true; }
    }
}
