using OpenQA.Selenium.Appium;
using OpenQA.Selenium.Appium.Windows;

namespace AutoTestForWpfApp
{
	public class Tests
	{
		public const string DriverUrl = "http://127.0.0.1:4723/";
		[SetUp]
		public void Setup()
		{
		}

		[Test]
		public void Test_CheckDog_LifeTime()
		{
			// run WPF exe
			string appWPF = @"D:\WpfAppAnimal\bin\Debug\WpfAppAnimal.exe";
			var options = new AppiumOptions();
			options.AddAdditionalCapability("app", appWPF);
			WindowsDriver<WindowsElement> session = new WindowsDriver<WindowsElement>(new Uri(DriverUrl), options);

			// wait running WPF (3 seconds)
			Thread.Sleep(3000);

			WindowsElement element = null;

			// autotest write in wpf application text "dog"
			element = session.FindElementByAccessibilityId("AnimalNameTextId");
			element.SendKeys("dog");

			// autotest click button in wpf application
			element = session.FindElementByAccessibilityId("CalculateButtonId");
			element.Click();

			// autotest get text from wpf application
			element = session.FindElementByAccessibilityId("LifeTimeTextId");

			Assert.AreEqual("16 years", element.Text);

			// close wpf application
			session.Quit();
		}
	}
}




