using OpenQA.Selenium.Appium;
using OpenQA.Selenium.Appium.Windows;

namespace AutoNUnitTest1
{
	public class Tests
	{
		[SetUp]
		public void Setup()
		{
		}

		[Test]
		public void Test1()
		{
			const string WindowsApplicationDriverUrl = "http://127.0.0.1:4723";
			const string CalculatorAppId = "Microsoft.WindowsCalculator_8wekyb3d8bbwe!App";

			AppiumOptions appCapabilities = new AppiumOptions();
			appCapabilities.AddAdditionalCapability("app", CalculatorAppId);
			appCapabilities.AddAdditionalCapability("deviceName", "WindowsPC");
			var session = new WindowsDriver<WindowsElement>(new Uri(WindowsApplicationDriverUrl), appCapabilities);
			Assert.IsNotNull(session);

			session.Manage().Timeouts().ImplicitWait = TimeSpan.FromSeconds(1.5);

			// auto test click "6"
			session.FindElementByName("Six").Click();

			// auto test click "+"
			session.FindElementByName("Plus").Click();

			// auto test click "3"
			session.FindElementByName("Three").Click();

			// auto test click "="
			session.FindElementByAccessibilityId("equalButton").Click();

			// auto test get value
			string valueFromApplication = session.FindElementByAccessibilityId("CalculatorResults").Text;

			Assert.That(valueFromApplication, Is.EqualTo("Display is 9"));
		}
	}
}