var React = require("react");
var ReactDOM = require("react-dom");
import { Component } from "react";
import axios from 'axios';

class MyApp extends Component {

    onLoginSubmit(e) {
        e.preventDefault();

        let urlLogin = "https://dir.by/developer/myapi/login.php";

        let sendObject = { 'login': e.target.login.value, 'password': e.target.password.value };

        let axiosConfig = { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } };

        axios.post(urlLogin, sendObject, axiosConfig)
            .then(function (response) {
                alert(JSON.stringify(response.data))
            })
            .catch(function (error) {
                alert("Error ! " + error)
            });
    }

    render() {
        return (
            <div class="container1">
                <div class="container2">
                    <div class="form1">
                        <h2> Welcome </h2>
                        <form onSubmit={this.onLoginSubmit}>
                            <div>
                                <input type="text" name="login" />
                            </div>
                            <div className="vert1">
                                <input type="text" name="password" />
                            </div>
                            <div className="vert1">
                                <button>Login</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        );
    }
}

ReactDOM.render(
    <MyApp ></MyApp>,
    document.getElementById('my_container'));