﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Net;
using System.IO;

namespace WpfApplication5
{
	/// <summary>
	/// Interaction logic for MainWindow.xaml
	/// </summary>
	public partial class MainWindow : Window
	{
		// memebers
		public FtpWebRequest _ftpRequest;
		public FtpWebResponse _ftpResponse;
		public Stream _responseStream;
		public int _pos = 5;
		public int _need_read_byte = 6;

		public MainWindow()
		{
			InitializeComponent();

			// status
			this.Status.Content = "FTP not connected";
			this.Url.Text = "ftp://";
		}

		private void Connect_Click(object sender, RoutedEventArgs e)
		{
			String strURL = this.Url.Text;
			String strLogin = this.Login.Text;
			String strPassword = this.Password.Text;

			try
			{
				// create ftp connection
				_ftpRequest = (FtpWebRequest)WebRequest.Create(strURL);
				_ftpRequest.Credentials = new NetworkCredential(strLogin, strPassword);

				// ftp method
				_ftpRequest.Method = WebRequestMethods.Ftp.DownloadFile;

				_ftpRequest.ContentOffset = _pos; // offset

				// get ftp response
				_ftpResponse = (FtpWebResponse)_ftpRequest.GetResponse();

				// get stream
				_responseStream = _ftpResponse.GetResponseStream();

				// show result
				this.Status.Content = "FTP succecfull";
			}
			catch (Exception exc)
			{
				MessageBox.Show(exc.Message);
			}

		}

		private void GetData_Click(object sender, RoutedEventArgs e)
		{

			try
			{
				// read file
				byte[] buffer = new byte[1024];
				int result_read_byte = _responseStream.Read(buffer, 0, _need_read_byte);

				// split
				buffer = buffer.Take(result_read_byte).ToArray();

				// convert to string
				string fileString = System.Text.Encoding.UTF8.GetString(buffer);

				// show result
				this.Status.Content = "Прочитано "  + result_read_byte + " байт " + " с позиции " + _pos;

				this.DataText.Text = fileString;

				// pos
				_pos += result_read_byte;
			}
			catch(Exception exc)
			{
				MessageBox.Show(exc.Message);
			}
		}
	}
}
