#include "opengl_es_windows/include/EGL/egl.h"
#include "opengl_es_windows/include/GLES2/gl2.h"

class MyGame
{
	// constructor
	public: MyGame();

	// fields
	protected: EGLDisplay m_Display = EGL_NO_DISPLAY;
	protected: EGLSurface m_Surface = EGL_NO_SURFACE;
	protected: EGLContext m_Context = EGL_NO_CONTEXT;
	protected: EGLConfig m_configOpenGL = nullptr;
	protected: int m_Width;
	protected: int m_Height;

	// events
	public: void OnActiveFocus();
	public: void OnLostFocus();
	public: bool OnHandleTouch();
	public: void OnNextTick();

	// OpenGL
	public: void CreateSurfaceFromWindow_OpenGL(HWND window);
	public: void KillSurface_OpenGL();
	public: bool MakeCurrent_Display_Surface_Context_OpenGL();
	public: bool InitGraphic_OpenGL(HWND window);
	public: void CloseGraphic_OpenGL();
	public: void DrawGraphic_OpenGL();
};