package com.example.androidkotlinapp1

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.os.Parcel

import android.os.Parcelable // interface Parcelable defined in standard Java

import kotlinx.android.parcel.Parcelize // attribute @Parcelize defined in Kotlin extension
// 'org.jetbrains.kotlin:kotlin-android-extensions-runtime:1.7.0'

@Parcelize
data class MyBook(
	val id: Int,
	val title: String?,
	val price: Int
) : Parcelable


class MainActivity : AppCompatActivity() {
	override fun onCreate(savedInstanceState: Bundle?) {
		super.onCreate(savedInstanceState)
		setContentView(R.layout.activity_main)

		val book1 = MyBook(id=3, title = "Hello", price = 20)

		val parcel = Parcel.obtain()
		book1.writeToParcel(parcel, 0)

		parcel.setDataPosition(0)

		val book1FromParcel = MyHelper().MyCreator<MyBook>().createFromParcel(parcel)

	}
}

class MyHelper
{
	inline fun <reified T : Parcelable> MyCreator(): Parcelable.Creator<T>
	{
		return T::class.java.getDeclaredField("CREATOR").get(null) as Parcelable.Creator<T>
	}
}